package w83b.w83bDAO;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bRegistroDefinitivoBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bListImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bRegistroDefinitivoBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bRegistroDefinitivoDAO.
 * @author a
 */
public class W83bRegistroDefinitivoDAO implements W83bIRegistroDefinitivoDAO {
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIRegistroDefinitivoDAO#comprobarFechaRegistro(java.lang.String)
	 */
	public w83b.w83bBeans.W83bRegistroDefinitivoBean comprobarFechaRegistro(java.lang.String param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		W83bRegistroDefinitivoBean rd = new W83bRegistroDefinitivoBean();
		strSql.append("SELECT TO_CHAR(MAX("); 
		strSql.append(W83bRegistroDefinitivoBD.fechaRegistro);
		strSql.append("),'dd/MM/yyyy')");
		strSql.append(" FROM ").append(W83bRegistroDefinitivoBD.vistaActas);
		strSql.append(" WHERE ");
		strSql.append(W83bRegistroDefinitivoBD.territorio).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.fechaBaja).append(" IS NULL");
		
		params.add(param);
		
		List listaFechas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if (listaFechas!=null&&listaFechas.get(0)!=null){
			String dia=((String)listaFechas.get(0)).substring(0,2);
			String mes=((String)listaFechas.get(0)).substring(3,5);
			String anno=((String)listaFechas.get(0)).substring(6,10);
			
			Calendar cal = GregorianCalendar.getInstance();
			cal.set(Integer.parseInt(anno), Integer.parseInt(mes)-1, Integer.parseInt(dia)-1);
			
			long numDias = this.sacarDiferenciaDias(cal.get(Calendar.DATE),cal.get(Calendar.MONTH)+1,cal.get(Calendar.YEAR));			
			rd.setNumDias(String.valueOf(numDias));
			rd.setFechaRegistro((String)listaFechas.get(0));
		}
		else{
			rd.setNumDias("0");
			rd.setFechaRegistro("");
		}
		
		return rd; 
		
	}
	
	/**
	 * Sacar diferencia dias.
	 * 
	 * @param dia the dia
	 * @param mes the mes
	 * @param anno the anno
	 * @return the long
	 */
	public long sacarDiferenciaDias(int dia, int mes, int anno){
		long day_diff=0;
		try{
			Calendar cal = GregorianCalendar.getInstance();
			cal.set(anno, mes-1, dia);
			Date OldDate = cal.getTime();
			
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(new Date());
			Date TodaysDate = calendar.getTime();

			long mills_per_day = 1000 * 60 * 60 * 24;

			//Debido a que cuando se crear el propio Date se mete la hora (12:34) al calcular los dias justos no salen exactos, 
			//la divisin tiene resto, es decir perdemos tiempo. Para ello se va a restar el resto de la divisin para que 
			//el Date salga solo con das.
			long diferencia = TodaysDate.getTime()% mills_per_day;
			long diferenciaOld = OldDate.getTime()% mills_per_day;

			day_diff = ( (TodaysDate.getTime()-diferencia)- (OldDate.getTime()-diferenciaOld))/ mills_per_day  ;

		}catch (Exception e){

			W83bClsTrazas.traza(null, e.getLocalizedMessage());
		}
		
		return  day_diff-1;
	}
	
	/**
	 * Sign.
	 * 
	 * @param value the value
	 * @return the long
	 */
	public long sign(long value) {
	    return value & 0x8000000000000000L;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIRegistroDefinitivoDAO#calcularNumeroRegistro(w83b.w83bBeans.W83bRegistroDefinitivoBean)
	 */
	public java.lang.String calcularNumeroRegistro(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String numRegistro;            
		strSql.append("SELECT NVL (MAX ("); 
		strSql.append(W83bRegistroDefinitivoBD.numRegistro);
		strSql.append("), 0)");
		strSql.append(" FROM ").append(W83bRegistroDefinitivoBD.vistaActas);
		strSql.append(" WHERE ");
		strSql.append(W83bRegistroDefinitivoBD.territorio).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bRegistroDefinitivoBD.annoRegistro).append("=?");
		params.add(param.getTerritorio());
		params.add(param.getAnnoRegistro());
		
		List listaNumeros = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		int n=Integer.parseInt(String.valueOf(listaNumeros.get(0)))+1;
		numRegistro=String.valueOf(n);
		
		
		return numRegistro; 
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIRegistroDefinitivoDAO#modificarRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean)
	 */
	public java.util.List modificarRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
	   
		long milisegundos = System.currentTimeMillis();
	
		List params=new ArrayList();
	    
	    StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	    strSql.append("SELECT ");

	    strSql.append(W83bRegistroDefinitivoBD.numRegistroDef);
	    strSql.append(",");
	    strSql.append("TO_CHAR(").append(W83bRegistroDefinitivoBD.fechaEntrada).append(",?) AS ").append(W83bRegistroDefinitivoBD.fechaEntrada);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numeroEntrada);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numeroActa);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.cif);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numeroCentro);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.razon);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.direccion);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.municipio);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.provincia);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numTrabajadores);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numDelegados);
	    strSql.append(",");
	    strSql.append(W83bRegistroDefinitivoBD.seccion);
	    strSql.append(" FROM TABLE (");
	    strSql.append(W83bRegistroDefinitivoBD.procRealizarRegistroDefinitivoMod);
	    strSql.append("(?,?,?,?,?))");
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistro(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEntrada(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(param.getTerritorio());
	    params.add(param.getNumRegistro());
	    params.add(param.getAnnoRegistro());
	    
	    List actas = W83bDataBase.executeQuery(strSql.toString(),params,W83bRegistroDefinitivoBean.class, param.getUsuarioBean(), null);
	    
	    W83bClsTrazas.formatTraza(param.getUsuarioBean(),"Query OK -> "+ (System.currentTimeMillis()- milisegundos) + " ms");	 
	
		return actas;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIRegistroDefinitivoDAO#consultarActasRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean)
	 */
	public java.util.List consultarActasRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
	    strSql.append("SELECT ").append(W83bRegistroDefinitivoBD.numRegistroDef).append(",");
	    strSql.append("TO_CHAR(").append(W83bRegistroDefinitivoBD.fechaEntrada).append(",?) AS ").append(W83bRegistroDefinitivoBD.fechaEntrada).append(",");
	    strSql.append("TO_CHAR(").append(W83bRegistroDefinitivoBD.fechaEleccion).append(",?) AS ").append(W83bRegistroDefinitivoBD.fechaEleccion).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numeroEntrada).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numeroActa).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.anoacta).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.ter).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.ver).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.cif).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numeroCentro).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.codcentro).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.razon).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.direccion).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.municipio).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.provincia).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numTrabajadores).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.numDelegados).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.npreaviso).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.anopreaviso).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.actatotal).append(",");
	    strSql.append(W83bRegistroDefinitivoBD.seccion).append(" FROM TABLE (");
	    strSql.append(W83bRegistroDefinitivoBD.procRealizarRegistroDefinitivo);
	    strSql.append("(?,?,?,?,?))");
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    params.add("");
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEntrada(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(param.getTerritorio());
	    params.add("");
	    params.add("");
		
		if (param.getIdColumna()!=null&&!"".equals(param.getIdColumna())){
			if (W83bRegistroDefinitivoBD.numeroEntrada.equals(param.getIdColumna())){
				if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
					strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort()).append(", TO_DATE(").append(W83bRegistroDefinitivoBD.fechaEntrada).append(",'dd/MM/yyyy') ").append(" ASC ");
				}
				else{
					strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort()).append(", TO_DATE(").append(W83bRegistroDefinitivoBD.fechaEntrada).append(",'dd/MM/yyyy') ").append(" ASC ");
				}
			}
			else{
				if (W83bRegistroDefinitivoBD.fechaEntrada.equals(param.getIdColumna())){
					if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())){
						strSql.append(" ORDER BY TO_DATE(").append(param.getIdColumna()).append(",'dd/MM/yyyy') ").append(param.getSort());
					}
					else{
						strSql.append(" ORDER BY TO_DATE(").append(param.getIdColumna()).append(",'yyyy/MM/dd') ").append(param.getSort());
					}
				}
				else{
					strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
				}
			}
			
		}
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bRegistroDefinitivoBean.class,param.getUsuarioBean(), param.getIdioma());
		
		return listaActas;		
		
	}
	
	public w83b.w83bBeans.W83bRegistroDefinitivoBean obtenerMunicipio(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		String m="";
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");

	    strSql.append("UPPER(").append(W83bRegistroDefinitivoBD.dso).append(")").append(" AS ").append(W83bRegistroDefinitivoBD.descmunicipio);
	    
	    strSql.append(", ");
	    		
	    strSql.append(W83bRegistroDefinitivoBD.comarcaid).append(" AS ").append(W83bRegistroDefinitivoBD.idcomarca);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.tablamunicipio);
	    
	    strSql.append(" WHERE ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.provinciaid).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.id).append("=?");
	    
	    if (param.getProvincia().length()==1){
	    	p="0"+param.getProvincia();
	    }
	    else{
	    	p=param.getProvincia();
	    }
	    
	    if (param.getMunicipio().length()==1){
	    	m="00"+param.getMunicipio();
	    }else if (param.getMunicipio().length()==2){
	    	m="0"+param.getMunicipio();
	    }
	    else{
	    	m=param.getMunicipio();
	    }
	    params.add(p);
	    params.add(m);
		
	    List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bRegistroDefinitivoBean.class,param.getUsuarioBean(), null);
		return (W83bRegistroDefinitivoBean)lista.get(0);		
		
	}
	
	public w83b.w83bBeans.W83bRegistroDefinitivoBean obtenerComarca(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String c="";
		String p="";
		
	    strSql.append("SELECT ");

	    strSql.append("UPPER(").append(W83bRegistroDefinitivoBD.dso).append(")").append(" AS ").append(W83bRegistroDefinitivoBD.desccomarca);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.tablacomarca);
	    
	    strSql.append(" WHERE ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.provinciaid).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.id).append("=?");
	    
	    if (param.getProvincia().length()==1){
	    	p="0"+param.getProvincia();
	    }
	    else{
	    	p=param.getProvincia();
	    }
	    if (param.getIdcomarca().length()==1){
	    	c="0"+param.getIdcomarca();
	    }
	    else{
	    	c=param.getIdcomarca();
	    }
	    params.add(p);
	    params.add(c);
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bRegistroDefinitivoBean.class,param.getUsuarioBean(), null);
		
		return (W83bRegistroDefinitivoBean)lista.get(0);		
		
	}
	
	public boolean numdelegadosescrtdif(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		boolean valido=false;
		List params = new ArrayList();
		
	    strSql.append("SELECT ");

	    strSql.append(W83bRegistroDefinitivoBD.totaldelegados);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.w83bdelegadosescrtdif);
	    
	    strSql.append(" WHERE ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.numeroActa).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.ter).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.anoacta).append("=?");
	    
	    strSql.append(" AND ");
	    
	    strSql.append(W83bRegistroDefinitivoBD.ver).append("=?");
	    
	    params.add(param.getNumeroActa());
	    params.add(param.getTerritorio());
	    params.add(param.getAnoacta());
	    params.add(param.getVer());
	    
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bRegistroDefinitivoBean.class,param.getUsuarioBean(), null);
		
		if (lista!=null){
			if (Integer.parseInt(((W83bRegistroDefinitivoBean)lista.get(0)).getTotaldelegados())==Integer.parseInt(param.getNumDelegados())){
				valido=true;
			}
		}
		
		return valido;		
		
	}
	
	public void anyadirHistorialTramitacion(W83bRegistroDefinitivoBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		
		strSql.append("(");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuario);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaTram);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),?,?,to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"'))");
		
		params.add(new Integer(param.getNumeroActa()));
		params.add(new Integer(param.getAnoacta()));
		params.add(param.getTerritorio());
		params.add(param.getVer());
		params.add(new Integer(W83bClsConstantes.TRAMITE_ACTA_ALTA));
		params.add(new Integer(W83bClsConstantes.FASE_TRAMITACION_ACEPTACION_ACTAS));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(sdf.format(new Date()));
		SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
		params.add(hoy.format(new Date()));
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
	}
	
	public java.lang.String modificarActaRegistroDefinitivo(w83b.w83bBeans.W83bRegistroDefinitivoBean registro,w83b.w83bBeans.W83bRegistroDefinitivoBean param,int i) throws Exception{
		List params;
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
	    params = new ArrayList();//NOPMD
		strSql.append("UPDATE ");
		strSql.append(W83bRegistroDefinitivoBD.vistaActas);
		strSql.append(" SET ");
		strSql.append(W83bRegistroDefinitivoBD.annoRegistro).append("=?");
		strSql.append(" , ");
		strSql.append(W83bRegistroDefinitivoBD.numRegistro).append("=?");
		strSql.append(" , ");
		strSql.append(W83bRegistroDefinitivoBD.fechaRegistro).append("=TO_DATE(?,'dd/MM/yyyy')");
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=?");
		/*strSql.append(" AND ");
		strSql.append(W83bActasBD.versionActa).append("=?");*/
		params.add(param.getAnnoRegistro());
		params.add(new Integer(Integer.parseInt(param.getNumRegistro())+i));
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistro(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		params.add(registro.getNumeroActa());
		params.add(registro.getAnoacta());
		params.add(registro.getTerritorio());
		//params.add(registro.getVer());
		W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		
		return "0";		
	}
	
	public List impugnacionesCorrectasPreavisos(W83bRegistroDefinitivoBean param) throws Exception {
		List params;
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
	    params = new ArrayList();//NOPMD
	    strSql.append("SELECT ");
	    strSql.append("I.");
	    strSql.append(W83bListImpugnacionesBD.n_impug);
	    strSql.append(", I. ");
	    strSql.append(W83bListImpugnacionesBD.fdeses);
	    strSql.append(", L. ");
	    strSql.append(W83bImpugnacionesBD.resultadoLaudos);
	    strSql.append(" FROM ");
	    strSql.append(W83bListImpugnacionesBD.tableImpugnaciones); 
		strSql.append(" I, ");
		strSql.append(W83bImpugnacionesBD.vistaLaudosImpugnacion);
		strSql.append(" L ");
		strSql.append("WHERE I.");
		strSql.append(W83bListImpugnacionesBD.n_impug);
		strSql.append("=L.");
		strSql.append(W83bImpugnacionesBD.numImpugnacionLaudos);
		strSql.append("(+) AND I.");
		strSql.append(W83bListImpugnacionesBD.agno_impug);
		strSql.append("=L.");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionLaudos);
		strSql.append("(+) AND I.");
		strSql.append(W83bListImpugnacionesBD.c_territ);
		strSql.append("=L.");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionLaudos);
		strSql.append("(+) AND I.");
		strSql.append(W83bListImpugnacionesBD.c_territ);
		strSql.append("=?");
		strSql.append(" AND I.");
		strSql.append(W83bListImpugnacionesBD.n_preaviso);
		strSql.append("=? ");
		strSql.append("AND I.");
		strSql.append(W83bListImpugnacionesBD.agno_preaviso);
		strSql.append("=?");
		
		params.add(param.getTerritorio());
		params.add(param.getNpreaviso());
		params.add(param.getAnopreaviso());
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bListImpugnacionesBean.class,param.getUsuarioBean(), null);
		
		return lista;
	}
	
	/**
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public List validarActaViva(String idCentroTrabajo,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT to_char(max(actasTemp.");
		strSql.append(W83bActasBD.fechaEleccion);
		strSql.append("),?) as ").append(W83bActasBD.fechaEleccion);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		strSql.append(" actasTemp WHERE actasTemp.").append(W83bActasBD.codCentro).append(" = ? ");
		params.add(idCentroTrabajo);		
		strSql.append(" and actasTemp.").append(W83bActasBD.fechaBaja).append(" is null ");
		strSql.append(" and actasTemp.").append(W83bActasBD.fecRegDefinitivo).append(" is not null ");
		strSql.append(" and actasTemp.").append(W83bActasBD.numRegDefinitivo).append(" is not null ");
		strSql.append(" and actasTemp.").append(W83bActasBD.validada).append("=1");
		//Incidencia Mantis 0045655:  que no sea un acta parcial, la vigencia de unas elecciones se calcula a partir de la ltima fecha de eleccin de una eleccon total (no parcial)
		strSql.append(" and actasTemp.").append(W83bActasBD.numTotalActa).append(" is  null ");	
		
		strSql.append(" and actasTemp.").append(W83bActasBD.versionActa).append(" = (select max(actasVer.");	
		strSql.append(W83bActasBD.versionActa);
		strSql.append(")");
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		strSql.append(" actasVer WHERE ");
		strSql.append(" actasTemp.").append(W83bActasBD.numActa).append(" = ");
		strSql.append(" actasVer.").append(W83bActasBD.numActa).append(" and ");
		strSql.append(" actasTemp.").append(W83bActasBD.anyoActa).append(" = ");
		strSql.append(" actasVer.").append(W83bActasBD.anyoActa).append(" and ");
		strSql.append(" actasTemp.").append(W83bActasBD.codTerritActa).append(" = ");
		strSql.append(" actasVer.").append(W83bActasBD.codTerritActa).append(" and ");
		strSql.append(" actasTemp.").append(W83bActasBD.codCentro).append(" = ");
		strSql.append(" actasVer.").append(W83bActasBD.codCentro);
		strSql.append(" and actasVer.").append(W83bActasBD.validada).append("=1)");
		

		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);		
		
		return listaActas;		
	}
	
	public String calcularFechaRegistroMaxima(w83b.w83bBeans.W83bRegistroDefinitivoBean param) throws Exception{
		String fechamaxima="";
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT TO_CHAR(MAX(");
		strSql.append(W83bRegistroDefinitivoBD.fechaRegistro);
		strSql.append("),'dd/MM/yyyy') as ").append(W83bRegistroDefinitivoBD.fechaRegistro);
		strSql.append(" FROM ").append(W83bRegistroDefinitivoBD.vistaActas);
		strSql.append(" WHERE ").append(W83bRegistroDefinitivoBD.territorio).append("=?");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" IS NULL");
		params.add(param.getUsuarioBean().getCodTerritorioDelegacion());
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		fechamaxima=(String)listaActas.get(0);
		return fechamaxima;
	}
	
	public String calcularNumActasNuevas(w83b.w83bBeans.W83bRegistroDefinitivoBean param, String fechamaxima) throws Exception{
		String numactas="";
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT COUNT(*) FROM ");
		strSql.append(W83bRegistroDefinitivoBD.vistaActas);
		strSql.append(" WHERE ");
		strSql.append(W83bRegistroDefinitivoBD.fechaRegistro);
		strSql.append("=TO_DATE(?,'dd/MM/yyyy')");
		params.add(fechamaxima);
		strSql.append(" AND ");
		strSql.append(W83bActasBD.nueva);
		strSql.append("=");
		strSql.append(W83bClsConstantes.UNO);
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa);
		strSql.append("=?");
		params.add(param.getUsuarioBean().getCodTerritorioDelegacion());
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" IS NULL");
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		numactas=((BigDecimal)lista.get(0)).toString();
		return numactas;
	}
	
	public List calcularActasFechaRegMax(w83b.w83bBeans.W83bRegistroDefinitivoBean param, String fechamaxima) throws Exception{
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bRegistroDefinitivoBD.nueva);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.ver);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.anoacta);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.ter);
		strSql.append(", "); 
		strSql.append(W83bRegistroDefinitivoBD.numeroActa);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.numeroEntrada);
		strSql.append(", ");
		strSql.append("TO_CHAR(").append(W83bRegistroDefinitivoBD.fechaEntrada).append(",?) AS ").append(W83bRegistroDefinitivoBD.fechaEntrada).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bRegistroDefinitivoBD.cif);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.numeroCentro);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.razon);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.direccion);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.numTrabajadores);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.municipio);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.provincia);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.seccion);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.fReg);
		strSql.append(", ");
		strSql.append(W83bRegistroDefinitivoBD.numDelegados);
		strSql.append(", ");
		strSql.append("TO_CHAR(").append(W83bRegistroDefinitivoBD.factu).append(",'dd/MM/yyyy') AS ").append(W83bRegistroDefinitivoBD.factu);
		strSql.append(" FROM ");
		strSql.append(W83bRegistroDefinitivoBD.w83bdeshacerregistro);
		strSql.append(" WHERE ");
		strSql.append(W83bRegistroDefinitivoBD.fReg);
		strSql.append("=TO_DATE(?,?)");
		params.add(fechamaxima);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(" AND ");
		strSql.append(W83bRegistroDefinitivoBD.ter);
		strSql.append("=?");
		params.add(param.getUsuarioBean().getCodTerritorioDelegacion());
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bRegistroDefinitivoBean.class,param.getUsuarioBean(), null);
		
		return listaActas;
	}
	
	public String calcularNumIncidActa(W83bRegistroDefinitivoBean acta) throws Exception{
		String numincidencias="";
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT COUNT(*)");
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" WHERE ").append(W83bIncidenciasBD.C_TERRIT_061).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bIncidenciasBD.N_ACTA_061).append("=?");
		strSql.append(" AND ");
		strSql.append(W83bIncidenciasBD.ANO_ACTA_061).append("=?");
		params.add(acta.getTerritorio());
		params.add(acta.getNumeroActa());
		params.add(acta.getAnoacta());
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		numincidencias=((BigDecimal)lista.get(0)).toString();
		return numincidencias;
	}
	
	public void modDatosRegistroActa(W83bRegistroDefinitivoBean acta) throws Exception{
		try{
			List params;
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		    params = new ArrayList();//NOPMD
			strSql.append("UPDATE ");
			strSql.append(W83bRegistroDefinitivoBD.vistaActas);
			strSql.append(" SET ");
			strSql.append(W83bRegistroDefinitivoBD.annoRegistro).append("=NULL");
			strSql.append(" , ");
			strSql.append(W83bRegistroDefinitivoBD.numRegistro).append("=NULL");
			strSql.append(" , ");
			strSql.append(W83bRegistroDefinitivoBD.fechaRegistro).append("=NULL");
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.numActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.anyoActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.codTerritActa).append("=?");
			params.add(acta.getNumeroActa());
			params.add(acta.getAnoacta());
			params.add(acta.getTerritorio());
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "ERROR en DAO==>modDatosRegistroActa",null);
			throw e;		
		}
	}

	public void borrarHistTramActa(W83bRegistroDefinitivoBean acta) throws Exception{
		try{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("DELETE FROM ");
			strSql.append(W83bActasBD.historial_tramitacion_Synonym);
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.hisTram_numActa);
			strSql.append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_anyoActa);
			strSql.append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_territActa);
			strSql.append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_tram);
			strSql.append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_fase);
			strSql.append("=?");
			
			params.add(new Integer(acta.getNumeroActa()));
			params.add(new Integer(acta.getAnoacta()));
			params.add(acta.getTerritorio());
			params.add(new Integer(W83bClsConstantes.TRAMITE_ACTA_ALTA));
			params.add(new Integer(W83bClsConstantes.FASE_TRAMITACION_ACEPTACION_ACTAS));
			
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "ERROR en DAO==>borrarHistTramActa",null);
			throw e;		
		}
	}
	
	public void cambiarEstadoIncidencias(W83bRegistroDefinitivoBean acta) throws Exception{
		try{
			List params;
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		    params = new ArrayList();//NOPMD
			strSql.append("UPDATE ");
			strSql.append(W83bIncidenciasBD.incidenciasSinonimo);
			strSql.append(" SET ");
			strSql.append(W83bIncidenciasBD.F_VALIDAC_061).append("=NULL");
			strSql.append(" , ");
			strSql.append(W83bIncidenciasBD.VALIDADA_061).append("=?");
			strSql.append(" WHERE ");
			strSql.append(W83bIncidenciasBD.N_ACTA_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.ANO_ACTA_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.C_TERRIT_061).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bIncidenciasBD.VALIDADA_061).append("<>?");
			params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
			params.add(acta.getNumeroActa());
			params.add(acta.getAnoacta());
			params.add(acta.getTerritorio());
			params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "ERROR en DAO==>cambiarEstadoIncidencias",null);
			throw e;		
		}
	}
	
	public void modDatosIncidActa(W83bRegistroDefinitivoBean acta) throws Exception{
		try{
			List params;
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		    params = new ArrayList();//NOPMD
			strSql.append("UPDATE ");
			strSql.append(W83bRegistroDefinitivoBD.vistaActas);
			strSql.append(" SET ");
			strSql.append(W83bRegistroDefinitivoBD.fechaactu).append("=TO_DATE(?,?)");
			W83bClsTrazas.trazaError(null, "fecha de actualizacion deshacer registrooooo==>acta.getFactu()",null);
			if (StringUtils.isNotEmpty(acta.getFactu())){
				W83bClsTrazas.trazaError(null, "fecha de actualizacion deshacer registrooooo==>acta.getFactu()",null);
				params.add(acta.getFactu());
			}
			else{
				W83bClsTrazas.trazaError(null, "fecha de actualizacion deshacer registrooooo==>vacio",null);
				params.add(W83bClsConstantes.NULL_DATE);
			}
			params.add("dd/MM/yyyy");
			strSql.append(" , ");
			strSql.append(W83bActasBD.validada).append("=?");
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.numActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.anyoActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.codTerritActa).append("=?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.versionActa).append(">?");
			strSql.append(" AND ");
			strSql.append(W83bActasBD.validada).append("<>?");
			params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
			params.add(acta.getNumeroActa());
			params.add(acta.getAnoacta());
			params.add(acta.getTerritorio());
			params.add(W83bClsConstantes.VERSION_PRIMERA);
			params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}catch (Exception e){
			W83bClsTrazas.trazaError(null, "ERROR en DAO==>modDatosIncidActa",null);
			throw e;		
		}
		
	}

}